CREATE FUNCTION [dbo].[CFUJ_Venta_Abono_Condiciones_Productos_Validar](@pJson VARCHAR(8000))
RETURNS TINYINT
AS
BEGIN
/*Variable Retorno*/
DECLARE @Flag_Validacion_OK		TINYINT
/*FIN Variable Retorno*/

/***************************************************************************************************

	Funcion:	        dbo.CFUJ_Venta_Abono_Condiciones_Productos_Validar
	Fecha de Creacion:  2023-08-14
	Creado por:         Adriana Laverde
	Descripcion:        Funcion encargada de validar los productos (NO FIJOS) de un evento
	Llamado por:        sys/kiosk/plateas_venta.php
	Tablas afectadas:   
	Usado en:           Venta de Abonos
	Parametro(s):       ModoDebug, Id_Cliente, Id_Evento, Fecha, Id_Producto
	Forma de uso:       SELECT dbo.CFUJ_Venta_Abono_Condiciones_Productos_Validar ('{"ModoDebug":"0", "Id_Cliente":"1974", "Id_Evento":"304", "Id_Producto":"'+CONVERT(VARCHAR(15),ISNULL('APOPLAD',''))+'", "Fecha":"2023-08-14T09:10:22"}') 
	Notas adicionales:  

	- Para utilizar esta función debe ser implementada solo para particularidades de validaciones de productos (NO FIJOS) en la venta de abono, si no se configura nada siempre debe devolver 1

	****************************************************************************************************

	SUMARIO DE CAMBIOS
	FECHA(yyyy-mm-dd)    Autor              Comentarios
	------------------- ------------------- ------------------------------------------------------------

              
***************************************************************************************************/

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pModoDebug			TINYINT
DECLARE @pId_Cliente		INT
DECLARE @pId_Evento			SMALLINT
DECLARE @pFecha				DATETIME
DECLARE @pId_Producto		VARCHAR(14)

SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), '')
SET @pId_Cliente			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pId_Evento				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Evento')), 0)
SET @pFecha					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha')), GETDATE())
SET @pId_Producto			= ISNULL(CONVERT(VARCHAR(14), dbo.CF_JSON_VALUE(@pJson,'Id_Producto')), GETDATE())
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variables Locales*/
DECLARE @Cliente_Activo									TINYINT
DECLARE @Cliente_Fecha_Alta								DATETIME
DECLARE @Cliente_Fecha_Baja								DATETIME
DECLARE @Cliente_Id_Cliente_Ref							INT
DECLARE @Cliente_Id_Cliente_Externo						VARCHAR(14)
DECLARE @Cliente_Razon_Social							VARCHAR(100)
DECLARE @Cliente_Fecha_Nac								DATETIME
DECLARE @Cliente_Edad									INT
DECLARE @Cliente_Id_Tipo_Cli							SMALLINT
DECLARE @Cliente_Doc_Nro								BIGINT
DECLARE @Cliente_Credencial_Nro							VARCHAR(30)
DECLARE @Cliente_Tipo_Persona							CHAR(1)
DECLARE @Cliente_Ult_Cuota_Paga							DATETIME
DECLARE @Cliente_Sexo									CHAR(1)
/*FIN Variables Locales*/


-----------------------------------------------------------------------------------------------------------------------------------------------
SELECT
@Cliente_Activo								= ISNULL(Activo, 0),
@Cliente_Fecha_Alta							= ISNULL(Fecha_Alta, '19000101'),
@Cliente_Fecha_Baja							= ISNULL(Fecha_Baja, '19000101'),
@Cliente_Id_Cliente_Ref						= ISNULL(Id_Cliente_Ref, 0),
@Cliente_Id_Cliente_Externo					= LTRIM(RTRIM(ISNULL(Id_Cliente_Externo, ''))),
@Cliente_Razon_Social						= LTRIM(RTRIM(ISNULL(Razon_Social, ''))),
@Cliente_Fecha_Nac							= ISNULL(Fecha_Nac, '19000101'),
@Cliente_Edad								= dbo.CF_Edad_Persona_A_UnaFecha(ISNULL(Fecha_Nac, '19000101'), @pFecha),
@Cliente_Id_Tipo_Cli						= ISNULL(Id_Tipo_Cli, 0),
@Cliente_Doc_Nro							= ISNULL(Doc_Nro, 0),
@Cliente_Credencial_Nro						= LTRIM(RTRIM(ISNULL(Credencial_Nro, ''))),
@Cliente_Tipo_Persona						= ISNULL(Tipo_Persona, 'F'), 
@Cliente_Ult_Cuota_Paga						= ISNULL(Ult_Cuota_Paga, '19000101'), 
@Cliente_Sexo								= ISNULL (Sexo, '')
FROM Clientes
WHERE
Id_Cliente = @pId_Cliente

-----------------------------------------------------------------------------------------------------------------------------------------------
SET @Flag_Validacion_OK = 1

/* IMPLEMENTAR */

--------------------------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------------------------
RETURN ISNULL(@Flag_Validacion_OK, 0)
END